
--
-- Indexes for dumped tables
--

--
-- Indexes for table `DATABASECHANGELOGLOCK`
--
ALTER TABLE `DATABASECHANGELOGLOCK`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `tc_attributes`
--
ALTER TABLE `tc_attributes`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tc_calendars`
--
ALTER TABLE `tc_calendars`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tc_commands`
--
ALTER TABLE `tc_commands`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tc_devices`
--
ALTER TABLE `tc_devices`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniqueid` (`uniqueid`),
  ADD KEY `fk_devices_groupid` (`groupid`),
  ADD KEY `id` (`id`,`name`,`category`),
  ADD KEY `positionid` (`positionid`),
  ADD KEY `disabled` (`disabled`);

--
-- Indexes for table `tc_device_attribute`
--
ALTER TABLE `tc_device_attribute`
  ADD KEY `fk_user_device_attribute_attributeid` (`attributeid`),
  ADD KEY `fk_user_device_attribute_deviceid` (`deviceid`);

--
-- Indexes for table `tc_device_command`
--
ALTER TABLE `tc_device_command`
  ADD KEY `fk_device_command_commandid` (`commandid`),
  ADD KEY `fk_device_command_deviceid` (`deviceid`);

--
-- Indexes for table `tc_device_driver`
--
ALTER TABLE `tc_device_driver`
  ADD KEY `fk_device_driver_deviceid` (`deviceid`),
  ADD KEY `fk_device_driver_driverid` (`driverid`);

--
-- Indexes for table `tc_device_geofence`
--
ALTER TABLE `tc_device_geofence`
  ADD KEY `fk_device_geofence_deviceid` (`deviceid`),
  ADD KEY `fk_device_geofence_geofenceid` (`geofenceid`);

--
-- Indexes for table `tc_device_maintenance`
--
ALTER TABLE `tc_device_maintenance`
  ADD KEY `fk_device_maintenance_deviceid` (`deviceid`),
  ADD KEY `fk_device_maintenance_maintenanceid` (`maintenanceid`);

--
-- Indexes for table `tc_device_notification`
--
ALTER TABLE `tc_device_notification`
  ADD KEY `fk_device_notification_deviceid` (`deviceid`),
  ADD KEY `fk_device_notification_notificationid` (`notificationid`);

--
-- Indexes for table `tc_drivers`
--
ALTER TABLE `tc_drivers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniqueid` (`uniqueid`);

--
-- Indexes for table `tc_events`
--
ALTER TABLE `tc_events`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_events_deviceid` (`deviceid`),
  ADD KEY `servertime` (`servertime`);

--
-- Indexes for table `tc_geofences`
--
ALTER TABLE `tc_geofences`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_geofence_calendar_calendarid` (`calendarid`);

--
-- Indexes for table `tc_groups`
--
ALTER TABLE `tc_groups`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_groups_groupid` (`groupid`);

--
-- Indexes for table `tc_group_attribute`
--
ALTER TABLE `tc_group_attribute`
  ADD KEY `fk_group_attribute_attributeid` (`attributeid`),
  ADD KEY `fk_group_attribute_groupid` (`groupid`);

--
-- Indexes for table `tc_group_command`
--
ALTER TABLE `tc_group_command`
  ADD KEY `fk_group_command_commandid` (`commandid`),
  ADD KEY `fk_group_command_groupid` (`groupid`);

--
-- Indexes for table `tc_group_driver`
--
ALTER TABLE `tc_group_driver`
  ADD KEY `fk_group_driver_driverid` (`driverid`),
  ADD KEY `fk_group_driver_groupid` (`groupid`);

--
-- Indexes for table `tc_group_geofence`
--
ALTER TABLE `tc_group_geofence`
  ADD KEY `fk_group_geofence_geofenceid` (`geofenceid`),
  ADD KEY `fk_group_geofence_groupid` (`groupid`);

--
-- Indexes for table `tc_group_maintenance`
--
ALTER TABLE `tc_group_maintenance`
  ADD KEY `fk_group_maintenance_groupid` (`groupid`),
  ADD KEY `fk_group_maintenance_maintenanceid` (`maintenanceid`);

--
-- Indexes for table `tc_group_notification`
--
ALTER TABLE `tc_group_notification`
  ADD KEY `fk_group_notification_groupid` (`groupid`),
  ADD KEY `fk_group_notification_notificationid` (`notificationid`);

--
-- Indexes for table `tc_maintenances`
--
ALTER TABLE `tc_maintenances`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tc_notifications`
--
ALTER TABLE `tc_notifications`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_notification_calendar_calendarid` (`calendarid`);

--
-- Indexes for table `tc_positions`
--
ALTER TABLE `tc_positions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `devicetime` (`devicetime`),
  ADD KEY `devicetime_2` (`devicetime`),
  ADD KEY `devicetime_3` (`devicetime`),
  ADD KEY `fixtime` (`fixtime`),
  ADD KEY `servertime` (`servertime`,`devicetime`,`fixtime`),
  ADD KEY `servertime_2` (`servertime`,`devicetime`,`fixtime`),
  ADD KEY `id` (`id`,`deviceid`),
  ADD KEY `latitude` (`latitude`,`longitude`,`speed`,`course`),
  ADD KEY `position_deviceid_fixtime` (`deviceid`,`fixtime`);

--
-- Indexes for table `tc_servers`
--
ALTER TABLE `tc_servers`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tc_statistics`
--
ALTER TABLE `tc_statistics`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tc_users`
--
ALTER TABLE `tc_users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `email` (`email`);

--
-- Indexes for table `tc_user_attribute`
--
ALTER TABLE `tc_user_attribute`
  ADD KEY `fk_user_attribute_attributeid` (`attributeid`),
  ADD KEY `fk_user_attribute_userid` (`userid`);

--
-- Indexes for table `tc_user_calendar`
--
ALTER TABLE `tc_user_calendar`
  ADD KEY `fk_user_calendar_calendarid` (`calendarid`),
  ADD KEY `fk_user_calendar_userid` (`userid`);

--
-- Indexes for table `tc_user_command`
--
ALTER TABLE `tc_user_command`
  ADD KEY `fk_user_command_commandid` (`commandid`),
  ADD KEY `fk_user_command_userid` (`userid`);

--
-- Indexes for table `tc_user_device`
--
ALTER TABLE `tc_user_device`
  ADD KEY `fk_user_device_deviceid` (`deviceid`),
  ADD KEY `user_device_user_id` (`userid`);

--
-- Indexes for table `tc_user_driver`
--
ALTER TABLE `tc_user_driver`
  ADD KEY `fk_user_driver_driverid` (`driverid`),
  ADD KEY `fk_user_driver_userid` (`userid`);

--
-- Indexes for table `tc_user_geofence`
--
ALTER TABLE `tc_user_geofence`
  ADD KEY `fk_user_geofence_geofenceid` (`geofenceid`),
  ADD KEY `fk_user_geofence_userid` (`userid`);

--
-- Indexes for table `tc_user_group`
--
ALTER TABLE `tc_user_group`
  ADD KEY `fk_user_group_groupid` (`groupid`),
  ADD KEY `fk_user_group_userid` (`userid`);

--
-- Indexes for table `tc_user_maintenance`
--
ALTER TABLE `tc_user_maintenance`
  ADD KEY `fk_user_maintenance_maintenanceid` (`maintenanceid`),
  ADD KEY `fk_user_maintenance_userid` (`userid`);

--
-- Indexes for table `tc_user_notification`
--
ALTER TABLE `tc_user_notification`
  ADD KEY `fk_user_notification_notificationid` (`notificationid`),
  ADD KEY `fk_user_notification_userid` (`userid`);

--
-- Indexes for table `tc_user_user`
--
ALTER TABLE `tc_user_user`
  ADD KEY `fk_user_user_userid` (`userid`),
  ADD KEY `fk_user_user_manageduserid` (`manageduserid`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `tc_attributes`
--
ALTER TABLE `tc_attributes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;
--
-- AUTO_INCREMENT for table `tc_calendars`
--
ALTER TABLE `tc_calendars`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `tc_commands`
--
ALTER TABLE `tc_commands`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;
--
-- AUTO_INCREMENT for table `tc_devices`
--
ALTER TABLE `tc_devices`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=465;
--
-- AUTO_INCREMENT for table `tc_drivers`
--
ALTER TABLE `tc_drivers`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;
--
-- AUTO_INCREMENT for table `tc_events`
--
ALTER TABLE `tc_events`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=46130151;
--
-- AUTO_INCREMENT for table `tc_geofences`
--
ALTER TABLE `tc_geofences`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;
--
-- AUTO_INCREMENT for table `tc_groups`
--
ALTER TABLE `tc_groups`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=215;
--
-- AUTO_INCREMENT for table `tc_maintenances`
--
ALTER TABLE `tc_maintenances`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;
--
-- AUTO_INCREMENT for table `tc_notifications`
--
ALTER TABLE `tc_notifications`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;
--
-- AUTO_INCREMENT for table `tc_positions`
--
ALTER TABLE `tc_positions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=125669388;
--
-- AUTO_INCREMENT for table `tc_servers`
--
ALTER TABLE `tc_servers`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT for table `tc_statistics`
--
ALTER TABLE `tc_statistics`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=348;
--
-- AUTO_INCREMENT for table `tc_users`
--
ALTER TABLE `tc_users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=213;
--
-- Constraints for dumped tables
--

--
-- Constraints for table `tc_devices`
--
ALTER TABLE `tc_devices`
  ADD CONSTRAINT `fk_devices_groupid` FOREIGN KEY (`groupid`) REFERENCES `tc_groups` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `tc_device_attribute`
--
ALTER TABLE `tc_device_attribute`
  ADD CONSTRAINT `fk_user_device_attribute_attributeid` FOREIGN KEY (`attributeid`) REFERENCES `tc_attributes` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_user_device_attribute_deviceid` FOREIGN KEY (`deviceid`) REFERENCES `tc_devices` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_device_command`
--
ALTER TABLE `tc_device_command`
  ADD CONSTRAINT `fk_device_command_commandid` FOREIGN KEY (`commandid`) REFERENCES `tc_commands` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_device_command_deviceid` FOREIGN KEY (`deviceid`) REFERENCES `tc_devices` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_device_driver`
--
ALTER TABLE `tc_device_driver`
  ADD CONSTRAINT `fk_device_driver_deviceid` FOREIGN KEY (`deviceid`) REFERENCES `tc_devices` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_device_driver_driverid` FOREIGN KEY (`driverid`) REFERENCES `tc_drivers` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_device_geofence`
--
ALTER TABLE `tc_device_geofence`
  ADD CONSTRAINT `fk_device_geofence_deviceid` FOREIGN KEY (`deviceid`) REFERENCES `tc_devices` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_device_geofence_geofenceid` FOREIGN KEY (`geofenceid`) REFERENCES `tc_geofences` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_device_maintenance`
--
ALTER TABLE `tc_device_maintenance`
  ADD CONSTRAINT `fk_device_maintenance_deviceid` FOREIGN KEY (`deviceid`) REFERENCES `tc_devices` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_device_maintenance_maintenanceid` FOREIGN KEY (`maintenanceid`) REFERENCES `tc_maintenances` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_device_notification`
--
ALTER TABLE `tc_device_notification`
  ADD CONSTRAINT `fk_device_notification_deviceid` FOREIGN KEY (`deviceid`) REFERENCES `tc_devices` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_device_notification_notificationid` FOREIGN KEY (`notificationid`) REFERENCES `tc_notifications` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_events`
--
ALTER TABLE `tc_events`
  ADD CONSTRAINT `fk_events_deviceid` FOREIGN KEY (`deviceid`) REFERENCES `tc_devices` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_geofences`
--
ALTER TABLE `tc_geofences`
  ADD CONSTRAINT `fk_geofence_calendar_calendarid` FOREIGN KEY (`calendarid`) REFERENCES `tc_calendars` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `tc_groups`
--
ALTER TABLE `tc_groups`
  ADD CONSTRAINT `fk_groups_groupid` FOREIGN KEY (`groupid`) REFERENCES `tc_groups` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `tc_group_attribute`
--
ALTER TABLE `tc_group_attribute`
  ADD CONSTRAINT `fk_group_attribute_attributeid` FOREIGN KEY (`attributeid`) REFERENCES `tc_attributes` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_group_attribute_groupid` FOREIGN KEY (`groupid`) REFERENCES `tc_groups` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_group_command`
--
ALTER TABLE `tc_group_command`
  ADD CONSTRAINT `fk_group_command_commandid` FOREIGN KEY (`commandid`) REFERENCES `tc_commands` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_group_command_groupid` FOREIGN KEY (`groupid`) REFERENCES `tc_groups` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_group_driver`
--
ALTER TABLE `tc_group_driver`
  ADD CONSTRAINT `fk_group_driver_driverid` FOREIGN KEY (`driverid`) REFERENCES `tc_drivers` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_group_driver_groupid` FOREIGN KEY (`groupid`) REFERENCES `tc_groups` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_group_geofence`
--
ALTER TABLE `tc_group_geofence`
  ADD CONSTRAINT `fk_group_geofence_geofenceid` FOREIGN KEY (`geofenceid`) REFERENCES `tc_geofences` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_group_geofence_groupid` FOREIGN KEY (`groupid`) REFERENCES `tc_groups` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_group_maintenance`
--
ALTER TABLE `tc_group_maintenance`
  ADD CONSTRAINT `fk_group_maintenance_groupid` FOREIGN KEY (`groupid`) REFERENCES `tc_groups` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_group_maintenance_maintenanceid` FOREIGN KEY (`maintenanceid`) REFERENCES `tc_maintenances` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_group_notification`
--
ALTER TABLE `tc_group_notification`
  ADD CONSTRAINT `fk_group_notification_groupid` FOREIGN KEY (`groupid`) REFERENCES `tc_groups` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_group_notification_notificationid` FOREIGN KEY (`notificationid`) REFERENCES `tc_notifications` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_notifications`
--
ALTER TABLE `tc_notifications`
  ADD CONSTRAINT `fk_notification_calendar_calendarid` FOREIGN KEY (`calendarid`) REFERENCES `tc_calendars` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `tc_positions`
--
ALTER TABLE `tc_positions`
  ADD CONSTRAINT `fk_positions_deviceid` FOREIGN KEY (`deviceid`) REFERENCES `tc_devices` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_user_attribute`
--
ALTER TABLE `tc_user_attribute`
  ADD CONSTRAINT `fk_user_attribute_attributeid` FOREIGN KEY (`attributeid`) REFERENCES `tc_attributes` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_user_attribute_userid` FOREIGN KEY (`userid`) REFERENCES `tc_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_user_calendar`
--
ALTER TABLE `tc_user_calendar`
  ADD CONSTRAINT `fk_user_calendar_calendarid` FOREIGN KEY (`calendarid`) REFERENCES `tc_calendars` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_user_calendar_userid` FOREIGN KEY (`userid`) REFERENCES `tc_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_user_command`
--
ALTER TABLE `tc_user_command`
  ADD CONSTRAINT `fk_user_command_commandid` FOREIGN KEY (`commandid`) REFERENCES `tc_commands` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_user_command_userid` FOREIGN KEY (`userid`) REFERENCES `tc_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_user_device`
--
ALTER TABLE `tc_user_device`
  ADD CONSTRAINT `fk_user_device_deviceid` FOREIGN KEY (`deviceid`) REFERENCES `tc_devices` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_user_device_userid` FOREIGN KEY (`userid`) REFERENCES `tc_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_user_driver`
--
ALTER TABLE `tc_user_driver`
  ADD CONSTRAINT `fk_user_driver_driverid` FOREIGN KEY (`driverid`) REFERENCES `tc_drivers` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_user_driver_userid` FOREIGN KEY (`userid`) REFERENCES `tc_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_user_geofence`
--
ALTER TABLE `tc_user_geofence`
  ADD CONSTRAINT `fk_user_geofence_geofenceid` FOREIGN KEY (`geofenceid`) REFERENCES `tc_geofences` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_user_geofence_userid` FOREIGN KEY (`userid`) REFERENCES `tc_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_user_group`
--
ALTER TABLE `tc_user_group`
  ADD CONSTRAINT `fk_user_group_groupid` FOREIGN KEY (`groupid`) REFERENCES `tc_groups` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_user_group_userid` FOREIGN KEY (`userid`) REFERENCES `tc_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_user_maintenance`
--
ALTER TABLE `tc_user_maintenance`
  ADD CONSTRAINT `fk_user_maintenance_maintenanceid` FOREIGN KEY (`maintenanceid`) REFERENCES `tc_maintenances` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_user_maintenance_userid` FOREIGN KEY (`userid`) REFERENCES `tc_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_user_notification`
--
ALTER TABLE `tc_user_notification`
  ADD CONSTRAINT `fk_user_notification_notificationid` FOREIGN KEY (`notificationid`) REFERENCES `tc_notifications` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_user_notification_userid` FOREIGN KEY (`userid`) REFERENCES `tc_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tc_user_user`
--
ALTER TABLE `tc_user_user`
  ADD CONSTRAINT `fk_user_user_manageduserid` FOREIGN KEY (`manageduserid`) REFERENCES `tc_users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_user_user_userid` FOREIGN KEY (`userid`) REFERENCES `tc_users` (`id`) ON DELETE CASCADE;
