<?php namespace Tobuli\Entities;

use Eloquent;
use Tobuli\Traits\Orderable;

class DevicePlan extends Eloquent
{
    use Orderable;

    protected $table = 'device_plans';

    protected $fillable = [
        'title',
        'price',
        'duration_type',
        'duration_value',
        'description',
        'active'
    ];

    public function deviceTypes()
    {
        return $this->belongsToMany(DeviceType::class);
    }

    public function getDurationTextAttribute()
    {
        return $this->duration_value.' '.self::getDurationType($this->duration_type);
    }

    public static function getDurationTypes()
    {
        return [
            'days' => trans('front.days'),
            'months' => trans('front.months'),
            'years' => trans('front.years'),
        ];
    }

    public static function getDurationType($type)
    {
        return self::getDurationTypes()[$type] ?? null;
    }

    public function scopeActive($query)
    {
        return $query->where('active', 1);
    }

    public function formatDuration()
    {
        if ($this->duration_value > 1)
            return $this->duration_value . " " . self::getDurationType($this->duration_type);

        switch ($this->duration_type) {
            case 'days':
                return trans('front.daily');
            case 'months':
                return trans('front.monthly');
            case 'years':
                return trans('front.yearly');
        }
    }

    public function formatPriceDuration()
    {
        return settings('currency.symbol') . $this->price . ' / ' . $this->formatDuration();
    }
}
