<?php

namespace Tobuli\Importers\Geofence;

use Tobuli\Importers\ImportManager;

class GeofenceImportManager extends ImportManager
{
    protected function getReadersList()
    {
        return [
            'kml'     => Readers\GeofenceKmlReader::class,
            'geojson' => Readers\GeofenceGeoJSONReader::class,
            'json'    => Readers\GeofenceGeoJSONReader::class,
            'gexp'    => Readers\GeofenceGexpReader::class,
        ];
    }

    protected function getImporterClass()
    {
        return GeofenceImporter::class;
    }
}