<?php

namespace Tobuli\Importers;

use Tobuli\Exceptions\ValidationException;

abstract class ImportManager implements ImportMangerInterface
{

    abstract protected function getReadersList();
    abstract protected function getImporterClass();

    /**
     * @throws \Exception
     */
    public function import($file, $additionals = [])
    {
        $importer = $this->resolve($file);

        $importer->import($file, $additionals);
    }

    /**
     * @throws \Exception
     */
    private function resolve($file)
    {
        // select reader only by file format
        $reader = $this->selectReader($file);

        if (is_null($reader)) {
            throw new ValidationException(['id' => trans('front.unsupported_format')]);
        }

        return $this->getImporter($reader);
    }

    private function getImporter($reader)
    {
        $class = $this->getImporterClass();

        return new $class($reader);
    }

    private function selectReader($file)
    {
        $readers = $this->getReadersList();

        return $this->forceFindReader($readers, $file);
    }

    private function forceFindReader($readers, $file)
    {
        foreach ($readers as $class) {
            $reader = app()->make($class);

            if ( ! $reader->isValidFormat($file)) {
                continue;
            }

            return $reader;
        }

        return null;
    }
}