<?php

namespace Tobuli\Importers\POI;

use Tobuli\Importers\ImportManager;

class POIImportManager extends ImportManager
{
    protected function getReadersList()
    {
        return [
            'kml'     => Readers\POIKmlReader::class,
            'gpx'     => Readers\POIGpxReader::class,
            'geojson' => Readers\POIGeoJSONReader::class,
            'json'    => Readers\POIGeoJSONReader::class,
            'csv'     => Readers\POICsvReader::class,
        ];
    }

    protected function getImporterClass()
    {
        return POIImporter::class;
    }
}