<?php

namespace Tobuli\Importers\Readers;

use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Validator;
use Tobuli\Importers\XlsCollectionImporter;

abstract class XlsReader extends Reader
{
    public function read($file)
    {
        $rows = [];
        $headerRow = null;

        $sheets = Excel::toCollection(new XlsCollectionImporter(), $file, null, \Maatwebsite\Excel\Excel::XLS);
        $rows = $sheets->first();
        $headerRow = $rows->shift()
            ->toArray();
        $rows = $rows->toArray();

        foreach ($rows as $key => $row) {
            $rows[$key] = array_combine($headerRow, $row);
        }

        if (! is_array($headerRow)) {
            return null;
        }

        if (empty($headerRow)) {
            return null;
        }

        if (empty($rows)) {
            return null;
        }

        return $rows;
    }

    public function isValidFormat($file)
    {
        $rows = [];
        $headerRow = null;

        try {
            $sheets = Excel::toCollection(new XlsCollectionImporter(), $file, null, \Maatwebsite\Excel\Excel::XLS);
            $rows = $sheets->first();
            $headerRow = $rows->shift()
                ->toArray();
            $rows = $rows->toArray();
        } catch(\PHPExcel_Reader_Exception $e) {
            return false;
        }

        if (empty($rows)) {
            return false;
        }

        if (! array_filter($headerRow)) {
            return false;
        }

        if (! isset($this->requiredFieldRules)) {
            return true;
        }

        return $this->validateRequiredFields(array_flip($headerRow));
    }

    protected function parseRow($row, $headers = [])
    {
        return empty($headers) ? $row : array_combine($headers, $row);
    }

    protected function validateRequiredFields($fieldNames)
    {
        $validator = Validator::make($fieldNames, $this->requiredFieldRules);

        if ($validator->fails()) {
            return false;
        }

        return true;
    }
}
