<?php

namespace Tobuli\Importers\Task\Readers;

use Maatwebsite\Excel\Facades\Excel;
use Tobuli\Importers\Readers\XlsReader;
use Tobuli\Importers\XlsCollectionImporter;

class TaskXlsReader extends XlsReader
{
    public function __construct()
    {
        $this->requiredFieldRules = [
            'title' => 'required',
            'device_id' => 'required_without:imei',
            'imei' => 'required_without:device_id',
            'priority' => 'required',
            'pickup_address_lat' => 'required',
            'pickup_address_lng' => 'required',
            'pickup_time_from' => 'required',
            'pickup_time_to' => 'required',
            'delivery_address_lat' => 'required',
            'delivery_address_lng' => 'required',
            'delivery_time_from' => 'required',
            'delivery_time_to' => 'required',
        ];
    }

    public function isValidFormat($file)
    {
        if (! parent::isValidFormat($file)) {
            return false;
        }

        $headerRow = null;

        try {
            $sheets = Excel::toCollection(new XlsCollectionImporter(), $file, null, \Maatwebsite\Excel\Excel::XLS);
            $rows = $sheets->first();
            $headerRow = $rows->first()
                ->toArray();
        } catch(\PHPExcel_Reader_Exception $e) {
            return false;
        }

        if (!$headerRow) {
            return false;
        }

        if (!is_array($headerRow) || !array_filter($headerRow)) {
            return false;
        }

        return true;
    }
}
