@extends('Frontend.Layouts.modal', ['modal_class' => 'modal-lg'])

@section('title')
    <i class="icon devices text-primary"></i> {{ trans('admin.device_plans') }}
@stop

@section('body')
    <div class="row">
        <div class="col-sm-12">
            <div class="form-group">
                {!! Form::label('entity', trans('validation.attributes.device_id')) !!}
                {!! Form::select('entity', $devices, $device_id, ['class' => 'form-control', 'id' => 'entity-select']) !!}
            </div>
        </div>
    </div>

    <div class="row">
        @foreach ($plans as $plan)
            <div class="col-sm-4">
                <div class="plan">
                    <div class="plan-heading">
                        <div class="plan-title">{{ $plan->title }}</div>
                    </div>

                    <table class="table">
                        <tbody>
                        <tr>
                            <td>{{ trans('front.duration') }}</td>
                            <td>{{ $plan->duration_text }}</td>
                        </tr>
                        <tr>
                            <td>{{ trans('global.price') }}</td>
                            <td>{{ $plan->price }}</td>
                        </tr>
                        </tbody>
                    </table>

                    <div class="plan-footer">
                        <a href="{{ route('payments.order', ['type' => 'device_plan', 'plan_id' => $plan->id, 'entity_type' => 'device']) }}"
                            class="btn btn-action btn-plan"
                            target="_blank">
                                {{ trans('front.upgrade') }}
                        </a>
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    <script>
        $(document).ready(function() {
            $('#entity-select').trigger('change');
        });

        $(document).on('change', '#entity-select', function() {
            var entity = $(this).val();

            $.each($('.plan .btn-plan'), function(index, btn) {
                $(btn).attr('href', updateUrlParameter($(btn).attr('href'), 'entity', entity));
            });
        });
    </script>
@stop

@section('buttons')
    <button type="button" class="btn btn-default" data-dismiss="modal">{!! trans('global.cancel') !!}</button>
@stop
