@extends('Frontend.Layouts.modal')

@section('title')
    <i class="icon task-import"></i> {{ trans('front.import') }}
@stop

@section('body')
    {!! Form::open(['route' => 'tasks.import_set', 'method' => 'POST', 'files' => true]) !!}
        <div class="form-group">
            {!! Form::label('file', trans('validation.attributes.file').'*:') !!}
            {!! Form::file('file', ['class' => 'form-control', 'accept' => '.xlsx, .xls, .csv']) !!}
        </div>
    {!! Form::close() !!}

    <div class="alert alert-info small">
        <a href="{{ asset('examples/import_task.csv') }}">example.csv</a>,
        <a href="{{ asset('examples/import_task.xls') }}">example.xls</a>
    </div>
@stop

@section('buttons')
    <button type="button" class="btn btn-action update_with_files">{{ trans('global.save') }}</button>
    <button type="button" class="btn btn-default" data-dismiss="modal">{{ trans('global.cancel') }}</button>
@stop
