<?php  namespace App\Http\Controllers\Api\Tracker;

use Illuminate\Routing\Controller;

use Tobuli\Entities\Device;
use Tobuli\Entities\Task;
use Tobuli\Entities\TaskStatus;
use Tobuli\Entities\User;
use Tobuli\Exceptions\ValidationException;

class ApiController extends Controller {

    protected $deviceInstance;

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $this->deviceInstance = app()->make(Device::class);

            return $next($request);
        });
    }

    public function login() {
        return response()->json(['success' => true, 'data' => ['device_id' => $this->deviceInstance->id]]);
    }
}