<?php

namespace App\Http\Controllers\Api\Tracker;

use Validator;
use Tobuli\Entities\File\DeviceMedia;
use Tobuli\Exceptions\ValidationException;
use Tobuli\Services\FileService;

class MediaController extends ApiController
{
    public function uploadImage()
    {
        $data = request()->all();

        if (isBase64($data['file'] ?? '')) {
            $data['file'] = base64ToImage($data['file']);
        }

        $validator = Validator::make($data, [
            'file' => 'required|image',
            'datetime' => 'required|date_format:Y-m-d H:i:s',
        ]);

        if ($validator->fails()) {
            throw new ValidationException($validator->messages());
        }

        $path = (new DeviceMedia())->getDirectory($this->deviceInstance);
        $timestamp = strtotime($data['datetime']);

        $fileService = new FileService();

        $filePath = $fileService->save($data['file'], $path);
        $fileService->setFileTimestamps($filePath, $timestamp);

        return response()->json([
            'status' => 1,
        ]);
    }
}
