<?php
namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Tobuli\Services\ChecklistService;

class ChecklistServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = true;
    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton('Tobuli\Services\ChecklistService', function ($app) {
            return new ChecklistService();
        });
    }
    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['Tobuli\Services\ChecklistService'];
    }
}
