<?php
// Facebook Multi Page/Group Poster v4
// Created by Novartis (Safwan)
if (count(get_included_files()) == 1) die();
if ($adminloggedIn || $loggedIn)
{
    if ($db = new PDO('sqlite:' . $dbName . '-logs.db'))
    {
        if ($adminloggedIn)
        {
            $statement = $db->prepare("SELECT COUNT(*) FROM Logs");
        }
        else
        {
            $statement = $db->prepare("SELECT COUNT(*) FROM Logs WHERE user = \"$fullname ($user)\"");
        }
        if ($statement)
        {
            $statement->execute();
        }
        else
        {
            showHTML("Log Retrieval Failed!");
        }
        $numr = $statement->fetchColumn();
        if (!$numr) showHTML($lang['No Logs'], $lang['Post Logs']);
        $numPerPage = 15;
        if (isset($_GET["start"]))
        {
            $start = $_GET["start"];
            if (($start % $numPerPage) != 0)
            {
                $start = $start - ($start % $numPerPage);
            }
        }
        else
        {
            $start = 0;
        }
        $numPages = floor($numr / $numPerPage);
        if (($numr % $numPerPage) != 0) $numPages += 1;
        $curPage = ($start / $numPerPage) + 1;
        if ($adminloggedIn)
        {
            $statement = $db->prepare("SELECT * FROM Logs ORDER BY date DESC LIMIT " . $start . "," . $numPerPage);
        }
        else
        {
            $statement = $db->prepare("SELECT * FROM Logs WHERE user = \"$fullname ($user)\" ORDER BY date DESC LIMIT " . $start . "," . $numPerPage);
        }
        if ($statement)
        {
            $statement->execute();
        }
        else
        {
            showHTML("Log Retrieval Failed x2!");
        }
        $tempData = $statement->fetchAll();
        if ($loggedIn && (isset($_COOKIE['FBMPGPTimezoneValue'])))
        {
            $timezoneString = $_COOKIE['FBMPGPTimezoneValue'];
            date_default_timezone_set($_COOKIE['FBMPGPTimezoneValue']);
        }
        $message = '<table class="table compact striped row-border table-border" cols=5 data-role="table" data-show-search="false" data-show-pagination="false" data-rows="-1" data-show-rows-steps="false" data-show-table-info="false" data-horizontal-scroll="true"><thead><tr><th>Time</th><th>' . $lang['Username'] . '</th><th>' . $lang['Page'] . '/' . $lang['Group'] . '</th><th>' . $lang['Information'] . '</th><th>' . $lang['Params'] . '</th></tr></thead><tbody>';
        foreach ($tempData as $s)
        {
            //print_r($s);
            //die();
            $dateTime = new DateTime(date('d-M-Y G:i', $s['date']));
            if (isset($day) && (($dateTime->format('d-M-Y')) != $day))
            {
                $day = $dateTime->format('d-M-Y');
                $message .= "<tr><td colspan=5></tr>";
            }
            else  $day = $dateTime->format('d-M-Y');
            $message .= "<tr><td> <span class='mif-";
            switch ($s['type'])
            {
                case 'T':
                    $message .= "file-text' title='TEXT'";
                    break;
                case 'L':
                    $message .= "link' title='LINK'";
                    break;
                case 'I':
                    $message .= "image' title='IMAGE'";
                    break;
                case 'A':
                    $message .= "images; title='ALBUM'";
                    break;
                case 'V':
                    $message .= "file-video' title='VIDEO'";
                    break;
                case 'S':
                    $message .= "file-image' title='Slideshow'";
                    break;
                case 'M':
                    $message .= "add-photo' title='Multi Image'";
                    break;
                default:
                    $message .= "question' title='Unknown'";
            }
            $message .= "></span>";
            $message .= " " . $dateTime->format('d-M-Y G:i');
            if ($loggedIn) $message .= "<br />($timezoneString)";
            $message .= "<td><strong>" . $s['user'] . "</strong><td>";
            $message .= ($s['targettype'] ? $lang['Group'] : $lang['Page']) . "&nbsp;<a target=_new href='http://www.facebook.com/" . $s['target'] . "'>" . $s['target'] . "</a>";
            $message .= "<td><div style='white-space: normal'>";
            if ($s['status'])
            {
                $message .= "$successImg <a target=_new href='" . $s['permalink'] . "'>" . $lang['Post Link'] . "</a>";
            }
            else
            {
                $message .= " <span class='tally h-100'>$failImg " . $s['action'] . "</span>";
            }
            $message .= "</div><td><div style='width:480px;white-space: normal;word-break: break-word;'>";
            $param = explode("|", $s['params']);
            foreach ($param as $p)
            {
                $temp = explode(":", $p);
                //list($k, $v) = explode(":",$p);
                if (($temp[0]) && ($temp[0] != "access_token") && ($temp[0] != "postType") && (($temp[0] != "file_url") || (strpos($s['params'], "URL:") === false)) && ($temp[0] != "targetID") && ($temp[0] != "isGroupPost") && (stripos($temp[0], "attached_media") === false)) $message .= "<strong>" . ucwords($temp[0]) . "</strong>: " . urldecode($temp[1]) . "<br />";
            }            
            $message .= "</div></tr>";
        }
        $message .= "</tbody></table>";
        if ($adminloggedIn)
        {
            $message .= "<br /><div class='text-center'><form method='GET'><input type=hidden name='clogs' value=1><input type=submit class='button rounded' value='" . $lang['Clear'] . " " . $lang['All'] . " " . $lang['Post Logs'] . "'></div></form>";
        }
        //Pagination of Results
        $message .= "<br><div>";
        if ($start > 0)
        {
            $message .= " | <a href='./?logs&start=0'>Newest</a>";
            if ($curPage > 2)
            {
                $message .= " | <a href='./?logs&start=" . ($start - $numPerPage) . "'>Newer</a>";
            }
        }
        $message .= " | <b>Page $curPage of $numPages</b>";
        if ($start < ($numr - $numPerPage))
        {
            if ($curPage <= ($numPages - 2))
            {
                $message .= " | <a href='./?logs&start=" . ($start + $numPerPage) . "'>Older</a>";
            }
            $message .= " | <a href='./?logs&start=" . (($numPages * $numPerPage) - $numPerPage) . "'>Oldest</a>";
        }
        $message .= " |</div>";
        showHTML($message, $lang['Post Logs']);
    }
}
?>