"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.header = void 0;
const utils_1 = require("../../../../utils");
const lib_1 = require("../../lib");
const header = (context, props) => {
    var _a;
    return (utils_1.JSX.createElement("header", null,
        utils_1.JSX.createElement("div", { class: "tsd-page-toolbar" },
            utils_1.JSX.createElement("div", { class: "container" },
                utils_1.JSX.createElement("div", { class: "table-wrap" },
                    utils_1.JSX.createElement("div", { class: "table-cell", id: "tsd-search", "data-base": context.relativeURL("./") },
                        utils_1.JSX.createElement("div", { class: "field" },
                            utils_1.JSX.createElement("label", { for: "tsd-search-field", class: "tsd-widget search no-caption" }, "Search"),
                            utils_1.JSX.createElement("input", { type: "text", id: "tsd-search-field" })),
                        utils_1.JSX.createElement("ul", { class: "results" },
                            utils_1.JSX.createElement("li", { class: "state loading" }, "Preparing search index..."),
                            utils_1.JSX.createElement("li", { class: "state failure" }, "The search index is not available")),
                        utils_1.JSX.createElement("a", { href: context.relativeURL("index.html"), class: "title" }, props.project.name)),
                    utils_1.JSX.createElement("div", { class: "table-cell", id: "tsd-widgets" },
                        utils_1.JSX.createElement("div", { id: "tsd-filter" },
                            utils_1.JSX.createElement("a", { href: "#", class: "tsd-widget options no-caption", "data-toggle": "options" }, "Options"),
                            utils_1.JSX.createElement("div", { class: "tsd-filter-group" },
                                utils_1.JSX.createElement("div", { class: "tsd-select", id: "tsd-filter-visibility" },
                                    utils_1.JSX.createElement("span", { class: "tsd-select-label" }, "All"),
                                    utils_1.JSX.createElement("ul", { class: "tsd-select-list" },
                                        utils_1.JSX.createElement("li", { "data-value": "public" }, "Public"),
                                        utils_1.JSX.createElement("li", { "data-value": "protected" }, "Public/Protected"),
                                        utils_1.JSX.createElement("li", { "data-value": "private", class: "selected" }, "All"))),
                                " ",
                                utils_1.JSX.createElement("input", { type: "checkbox", id: "tsd-filter-inherited", checked: true }),
                                utils_1.JSX.createElement("label", { class: "tsd-widget", for: "tsd-filter-inherited" }, "Inherited"),
                                !context.options.getValue("excludeExternals") && (utils_1.JSX.createElement(utils_1.JSX.Fragment, null,
                                    utils_1.JSX.createElement("input", { type: "checkbox", id: "tsd-filter-externals", checked: true }),
                                    utils_1.JSX.createElement("label", { class: "tsd-widget", for: "tsd-filter-externals" }, "Externals"))))),
                        utils_1.JSX.createElement("a", { href: "#", class: "tsd-widget menu no-caption", "data-toggle": "menu" }, "Menu"))))),
        utils_1.JSX.createElement("div", { class: "tsd-page-title" },
            utils_1.JSX.createElement("div", { class: "container" },
                !!props.model.parent && utils_1.JSX.createElement("ul", { class: "tsd-breadcrumb" }, context.breadcrumb(props.model)),
                utils_1.JSX.createElement("h1", null,
                    props.model.kindString !== "Project" && `${(_a = props.model.kindString) !== null && _a !== void 0 ? _a : ""} `,
                    props.model.name,
                    (0, lib_1.hasTypeParameters)(props.model) && (utils_1.JSX.createElement(utils_1.JSX.Fragment, null,
                        "<",
                        (0, lib_1.join)(", ", props.model.typeParameters, (item) => item.name),
                        ">")),
                    " ",
                    (0, lib_1.renderFlags)(props.model.flags))))));
};
exports.header = header;
