"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.memberSignatureBody = void 0;
const utils_1 = require("../../../../utils");
const models_1 = require("../../../../models");
const lib_1 = require("../../lib");
const memberSignatureBody = (context, props, { hideSources = false } = {}) => {
    var _a;
    return (utils_1.JSX.createElement(utils_1.JSX.Fragment, null,
        !hideSources && context.memberSources(props),
        context.comment(props),
        !!props.typeParameters && (utils_1.JSX.createElement(utils_1.JSX.Fragment, null,
            utils_1.JSX.createElement("h4", { class: "tsd-type-parameters-title" }, "Type parameters"),
            context.typeParameters(props.typeParameters))),
        props.parameters && props.parameters.length > 0 && (utils_1.JSX.createElement(utils_1.JSX.Fragment, null,
            utils_1.JSX.createElement("h4", { class: "tsd-parameters-title" }, "Parameters"),
            utils_1.JSX.createElement("ul", { class: "tsd-parameters" }, props.parameters.map((item) => (utils_1.JSX.createElement("li", null,
                utils_1.JSX.createElement("h5", null,
                    (0, lib_1.renderFlags)(item.flags),
                    !!item.flags.isRest && utils_1.JSX.createElement("span", { class: "tsd-signature-symbol" }, "..."),
                    item.name,
                    ": ",
                    context.type(item.type),
                    item.defaultValue != null && (utils_1.JSX.createElement("span", { class: "tsd-signature-symbol" },
                        " = ",
                        item.defaultValue))),
                context.comment(item),
                item.type instanceof models_1.ReflectionType && context.parameter(item.type.declaration))))))),
        props.type && (utils_1.JSX.createElement(utils_1.JSX.Fragment, null,
            utils_1.JSX.createElement("h4", { class: "tsd-returns-title" },
                "Returns ",
                context.type(props.type)),
            !!((_a = props.comment) === null || _a === void 0 ? void 0 : _a.returns) && (utils_1.JSX.createElement("div", null,
                utils_1.JSX.createElement(utils_1.Raw, { html: context.markdown(props.comment.returns) }))),
            props.type instanceof models_1.ReflectionType && context.parameter(props.type.declaration)))));
};
exports.memberSignatureBody = memberSignatureBody;
