<?php if(!empty($events)): ?>
    <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr data-event-id="<?php echo $item->id; ?>" onClick="app.events.select(<?php echo $item->id; ?>);">
            <td>
                <div class="row">
                    <div class="col-xs-3 datetime">
                        <span class="time"><?php echo e(Formatter::time()->formatTime(Formatter::time()->convert($item->time))); ?></span>
                        <span class="date"><?php echo e(Formatter::time()->formatDate(Formatter::time()->convert($item->time))); ?></span>
                    </div>

                    <div class="col-xs-4">
                        <?php echo e($item->device->name ?? ''); ?>

                    </div>
                    <div class="col-xs-5">
                        <?php echo e($item->title); ?>

                    </div>
                </div>

                <?php if(settings('plugins.event_section_address.status')): ?>
                    <div class="row">
                        <div class="col-sm-12">
                            <span data-device="address" data-lat="<?php echo e($item->latitude); ?>" data-lng="<?php echo e($item->longitude); ?>"></span>
                        </div>
                    </div>
                <?php endif; ?>
            </td>
            <td>
                <div class="btn-group dropleft droparrow"  data-position="fixed">
                    <i class="btn icon options" data-toggle="dropdown" data-position="fixed" aria-haspopup="true" aria-expanded="false"></i>
                    <ul class="dropdown-menu">
                        <li>
                            <a href="javascript:;" data-url="<?php echo e(route('alerts.edit', $item->alert_id)); ?>" data-modal="alerts_edit">
                                <span class="icon event"></span>
                                <span class="text"><?php echo e(trans('global.alert')); ?></span>
                            </a>
                        </li>

                        <li>
                            <a href="javascript:;" data-url="<?php echo e(route('events.do_destroy', ['id' => $item->id])); ?>" data-modal="events_do_destroy">
                                <span class="icon delete"></span>
                                <span class="text"><?php echo e(trans('global.delete')); ?></span>
                            </a>
                        </li>
                    </ul>
                </div>
            </td>
            <?php
                $arr = $item->toArray();
                $arr['time'] = Formatter::time()->human($item->time);
                unset($arr['geofence'], $arr['device'], $arr['alert'], $arr['poi']);
                if (isset($item->device) ?  : '')
                    $arr['device']['name'] = $item->device->name;
                if (isset($item->geofence->name) ?  : '')
                    $arr['geofence']['name'] = $item->geofence->name;
            ?>
            <script>app.events.add(<?php echo json_encode($arr); ?>);</script>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php if(method_exists($events, 'nextPageUrl') && $events->nextPageUrl()): ?>
        <tr>
            <td colspan="2" data-next="<?php echo $events->nextPageUrl(); ?>"></td>
        </tr>
    <?php endif; ?>
<?php else: ?>
    <tr>
        <td class="no-data"><?php echo trans('front.no_events'); ?></td>
    </tr>
<?php endif; ?>
