<?php $uid = uniqid(); ?>
<div class="input-group">
    <div class="has-feedback">
        <i class="icon address form-control-feedback"></i>
        <?php echo Form::text($type.'_address', $address, ['class' => 'form-control', 'placeholder' => trans('front.search_address'), 'autocomplete' => 'off', 'uid' => $uid]); ?>


    </div>
    <span class="input-group-btn">
            <a href="javascript:"
               id="<?php echo e($type); ?>_address_button"
               uid="<?php echo e($uid); ?>"
               class="form-control <?php echo e($type); ?>_address"
               data-url="<?php echo route('address.map'); ?>"
               data-modal="address_map"
               data-type="<?php echo e($type); ?>"
               data-parent="<?php echo e($parent); ?>"
               data-address="<?php echo e($address); ?>"
               data-lat="<?php echo e($lat); ?>"
               data-lng="<?php echo e($lng); ?>"
               type="button">
                <i class="icon search"></i>
            </a>
    </span>
</div>
<script>
    $(document).ready(function() {
        $('input[uid="<?php echo e($uid); ?>"]').on('click', function() {
            $(this).blur();
            $('a[uid="<?php echo e($uid); ?>"]').trigger('click');
        });
    });
</script>
