<!DOCTYPE html>
<!--[if IE 8]> <html lang="<?php echo e(Language::iso()); ?>" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="<?php echo e(Language::iso()); ?>" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="<?php echo e(Language::iso()); ?>" class="no-js">
<!--<![endif]-->

<head>
    <meta charset="utf-8"/>
    <title><?php echo e(Appearance::getSetting('server_name')); ?></title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
    <link rel="shortcut icon" href="<?php echo e(Appearance::getAssetFileUrl('favicon')); ?>"/>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset_resource('assets/css/'.Appearance::getSetting('template_color').'.css')); ?>" />

    <?php echo $__env->yieldContent('styles'); ?>
</head>

<body class="admin-layout">

<div class="header">
    <nav class="navbar navbar-main navbar-fixed-top">
        <div class="container-fluid">
            <div class="navbar-header">
                <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-header-navbar-collapse" aria-expanded="false">
                    <span class="sr-only">Toggle navigation</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>

                <?php if( Appearance::assetFileExists('logo') ): ?>
                <a class="navbar-brand" href="javascript:"><img src="<?php echo e(Appearance::getAssetFileUrl('logo')); ?>"></a>
                <?php endif; ?>

                <p class="navbar-text">ADMIN</p>
            </div>

            <div class="collapse navbar-collapse" id="bs-header-navbar-collapse">
                <ul class="nav navbar-nav navbar-right">
                    <?php echo getNavigation(); ?>

                </ul>
            </div>
        </div>
    </nav>
</div>

<div class="content">
    <div class="container-fluid">
        <?php if(Session::has('success')): ?>
            <div class="alert alert-success">
                <?php echo Session::get('success'); ?>

            </div>
        <?php endif; ?>
        <?php if(Session::has('error')): ?>
            <div class="alert alert-danger">
                <?php echo Session::get('error'); ?>

            </div>
        <?php endif; ?>

        <?php echo $__env->yieldContent('content'); ?>
    </div>
</div>

<div id="footer">
    <div class="container-fluid">
        <p>
            <span><?php echo e(date('Y')); ?> &copy; <?php echo e(Appearance::getSetting('server_name')); ?>

            | <?php echo e(CustomFacades\Server::ip()); ?>

            | v<?php echo e(config('tobuli.version')); ?>

            <?php if(Auth::User()->isAdmin()): ?>
                <?php if( $limit = CustomFacades\Server::getDeviceLimit()): ?>
                     | <?php echo e("1-$limit " . strtolower(trans('front.objects'))); ?>

                <?php endif; ?>

                | <?php echo e(trans('front.last_update')); ?>: <?php echo e(Formatter::time(CustomFacades\Server::lastUpdate())); ?>


                <?php if(CustomFacades\Server::isSpacePercentageWarning()): ?>
                    | <i style="color: red;">Server disk space is almost full</i>
                <?php endif; ?>
            <?php endif; ?>
            </span>
        </p>
    </div>
</div>

<?php echo $__env->make('Frontend.Layouts.partials.trans', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<script src="<?php echo e(asset_resource('assets/js/core.js')); ?>"></script>
<script src="<?php echo e(asset_resource('assets/js/app.js')); ?>"></script>

<?php echo $__env->make('Frontend.Layouts.partials.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<?php echo $__env->yieldContent('javascript'); ?>
<?php echo $__env->yieldPushContent('javascript'); ?>

<script>
    $.ajaxSetup({cache: false});
    window.lang = {
        nothing_selected: '<?php echo e(trans('front.nothing_selected')); ?>',
        color: '<?php echo e(trans('validation.attributes.color')); ?>',
        from: '<?php echo e(trans('front.from')); ?>',
        to: '<?php echo e(trans('front.to')); ?>',
        add: '<?php echo e(trans('global.add')); ?>'
    };
    app.lang = <?php echo json_encode(Language::get()); ?>;
    app.initSocket();
</script>

<div class="modal" id="modalDeleteConfirm">
    <div class="contents">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h3 class="modal-title thin" id="modalConfirmLabel"><?php echo e(trans('admin.delete')); ?></h3>
                </div>
                <div class="modal-body">
                    <p><?php echo e(trans('admin.do_delete')); ?></p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-main" onclick="modal_delete.del();"><?php echo e(trans('admin.yes')); ?></button>
                    <button class="btn btn-side" data-dismiss="modal" aria-hidden="true"><?php echo e(trans('global.cancel')); ?></button>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal" id="js-confirm-link" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
                loading
            </div>
            <div class="modal-footer" style="margin-top: 0">
                <button type="button" value="confirm" class="btn btn-main submit js-confirm-link-yes"><?php echo e(trans('admin.confirm')); ?></button>
                <button type="button" value="cancel" class="btn btn-side" data-dismiss="modal"><?php echo e(trans('admin.cancel')); ?></button>
            </div>
        </div>
    </div>
</div>
<div class="modal" id="modalError">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h3 class="modal-title thin" id="modalErrorLabel"><?php echo e(trans('global.error_occurred')); ?></h3>
            </div>
            <div class="modal-body">
                <p class="alert alert-danger"></p>
            </div>
            <div class="modal-footer">
                <button class="btn default" data-dismiss="modal" aria-hidden="true"><?php echo e(trans('global.close')); ?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal" id="modalSuccess">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h3 class="modal-title thin" id="modalSuccessLabel"><?php echo e(trans('global.warning')); ?></h3>
            </div>
            <div class="modal-body">
                <p class="alert alert-success"></p>
            </div>
            <div class="modal-footer">
                <button class="btn default" data-dismiss="modal" aria-hidden="true"><?php echo e(trans('global.close')); ?></button>
            </div>
        </div>
    </div>
</div>

</body>
</html>

 