<?php $__env->startSection('title'); ?>
    <i class="icon devices text-primary"></i> <?php echo e(trans('admin.device_plans')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
    <div class="row">
        <div class="col-sm-12">
            <div class="form-group">
                <?php echo Form::label('entity', trans('validation.attributes.device_id')); ?>

                <?php echo Form::select('entity', $devices, $device_id, ['class' => 'form-control', 'id' => 'entity-select']); ?>

            </div>
        </div>
    </div>

    <div class="row">
        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-sm-4">
                <div class="plan">
                    <div class="plan-heading">
                        <div class="plan-title"><?php echo e($plan->title); ?></div>
                    </div>

                    <table class="table">
                        <tbody>
                        <tr>
                            <td><?php echo e(trans('front.duration')); ?></td>
                            <td><?php echo e($plan->duration_text); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(trans('global.price')); ?></td>
                            <td><?php echo e($plan->price); ?></td>
                        </tr>
                        </tbody>
                    </table>

                    <div class="plan-footer">
                        <a href="<?php echo e(route('payments.order', ['type' => 'device_plan', 'plan_id' => $plan->id, 'entity_type' => 'device'])); ?>"
                            class="btn btn-action btn-plan"
                            target="_blank">
                                <?php echo e(trans('front.upgrade')); ?>

                        </a>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <script>
        $(document).ready(function() {
            $('#entity-select').trigger('change');
        });

        $(document).on('change', '#entity-select', function() {
            var entity = $(this).val();

            $.each($('.plan .btn-plan'), function(index, btn) {
                $(btn).attr('href', updateUrlParameter($(btn).attr('href'), 'entity', entity));
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('buttons'); ?>
    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo trans('global.cancel'); ?></button>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Frontend.Layouts.modal', ['modal_class' => 'modal-lg'], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>