<div class="panel panel-default">
    <div class="panel-heading">
        <div class="panel-title"><i class="icon stylize-1"></i> <?php echo e(trans('validation.attributes.logo')); ?></div>
    </div>

    <div class="panel-body">
        <?php echo Form::open(array('route' => 'admin.main_server_settings.logo_save', 'method' => 'POST', 'class' => 'form form-horizontal', 'enctype' => 'multipart/form-data', 'id' => 'logos-form')); ?>


            <div class="row">
                <div class="col-xs-6">
                    <div class="form-group">
                        <?php echo Form::label(null, trans('validation.attributes.frontpage_logo'), ['class' => 'col-xs-12 control-label"']); ?>

                        <div class="col-xs-12">
                            <div class="form-image">
                                <div class="form-image-controls">
                                    <label for="frontpage_logo" class="btn btn-default"><i class="icon upload"></i></label>
                                    
                                </div>
                                <?php if(Appearance::getAssetFilePath('logo')): ?>
                                    <img src="<?php echo e(Appearance::getAssetFileUrl('logo')); ?>" alt="Logo" class="img-responsive" id="img-frontpage-logo">
                                <?php endif; ?>
                                <img src="<?php echo e(asset('assets/images/no-image.jpg')); ?>" class="no-image img-responsive">
                                <?php echo Form::file('frontpage_logo', ['class' => 'hidden', 'id' => 'frontpage_logo', 'onChange' => 'readImage(this, "#img-frontpage-logo")']); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xs-6">
                    <div class="form-group">
                        <?php echo Form::label(null, trans('validation.attributes.favicon') . ' (16x16 .ICO)', ['class' => 'col-xs-12 control-label"']); ?>

                        <div class="col-xs-12">
                            <div class="form-image">
                                <div class="form-image-controls">
                                    <label for="favicon" class="btn btn-default"><i class="icon upload"></i></label>
                                    
                                </div>
                                <?php if(Appearance::getAssetFilePath('favicon')): ?>
                                    <img src="<?php echo e(Appearance::getAssetFileUrl('favicon')); ?>" alt="Logo" class="img-responsive" id="img-favicon">
                                <?php endif; ?>
                                <img src="<?php echo e(asset('assets/images/no-image.jpg')); ?>" class="no-image img-responsive">
                                <?php echo Form::file('favicon', ['class' => 'hidden', 'id' => 'favicon', 'onChange' => 'readImage(this, "#img-favicon")']); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xs-6">
                    <div class="form-group">
                        <?php echo Form::label('template_color', trans('validation.attributes.template_color'), ['class' => 'col-xs-12 control-label"']); ?>

                        <div class="col-xs-12">
                            <?php echo Form::select('template_color', config('tobuli.template_colors'), Appearance::getSetting('template_color'), ['class' => 'form-control']); ?>

                        </div>
                    </div>
                </div>
            </div>

            <hr>

            <div class="row">
                <div class="col-xs-6">
                    <div class="form-group">
                        <?php echo Form::label(null, trans('validation.attributes.login_page_logo'), ['class' => 'col-xs-12 control-label"']); ?>

                        <div class="col-xs-12">
                            <div class="form-image">
                                <div class="form-image-controls">
                                    <label for="login_page_logo" class="btn btn-default"><i class="icon upload"></i></label>
                                    
                                </div>
                                <?php if(Appearance::getAssetFilePath('logo-main')): ?>
                                <img src="<?php echo e(Appearance::getAssetFileUrl('logo-main')); ?>" alt="Logo" class="img-responsive" id="img-login-page-logo">
                                <?php endif; ?>
                                <img src="<?php echo e(asset('assets/images/no-image.jpg')); ?>" class="no-image img-responsive">
                                <?php echo Form::file('login_page_logo', ['class' => 'hidden', 'id' => 'login_page_logo', 'onChange' => 'readImage(this, "#img-login-page-logo")']); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xs-6">
                    <div class="form-group">
                        <?php echo Form::label(null, trans('validation.attributes.background'), ['class' => 'col-xs-12 control-label"']); ?>

                        <div class="col-xs-12">
                            <div class="form-image">
                                <div class="form-image-controls">
                                    <label for="background" class="btn btn-default"><i class="icon upload"></i></label>
                                    
                                </div>
                                <?php if(Appearance::getAssetFilePath('background')): ?>
                                <img src="<?php echo e(Appearance::getAssetFileUrl('background')); ?>" alt="Logo" class="img-responsive" id="img-backgroud">
                                <?php endif; ?>
                                <img src="<?php echo e(asset('assets/images/no-image.jpg')); ?>" class="no-image img-responsive">
                                <?php echo Form::file('background', ['class' => 'hidden', 'id' => 'background', 'onChange' => 'readImage(this, "#img-backgroud")']); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xs-6">
                    <div class="form-group">
                        <?php echo Form::label('login_page_text_color', trans('validation.attributes.login_page_text_color'), ['class' => 'col-xs-12 control-label"']); ?>

                        <div class="col-xs-12">
                            <?php echo Form::text('login_page_text_color', Appearance::getSetting('login_page_text_color'), ['class' => 'form-control colorpicker']); ?>

                        </div>
                    </div>
                </div>

                <div class="col-xs-6">
                    <div class="form-group">
                        <?php echo Form::label('login_page_background_color', trans('validation.attributes.login_page_background_color'), ['class' => 'col-xs-12 control-label"']); ?>

                        <div class="col-xs-12">
                            <?php echo Form::text('login_page_background_color', Appearance::getSetting('login_page_background_color'), ['class' => 'form-control colorpicker']); ?>

                        </div>
                    </div>
                </div>

                <div class="col-xs-6">
                    <div class="form-group">
                        <?php echo Form::label('login_page_panel_background_color', trans('validation.attributes.login_page_panel_background_color'), ['class' => 'col-xs-12 control-label"']); ?>

                        <div class="col-xs-12">
                            <?php echo Form::text('login_page_panel_background_color', Appearance::getSetting('login_page_panel_background_color'), ['class' => 'form-control colorpicker']); ?>

                        </div>
                    </div>
                </div>

                <div class="col-xs-6">
                    <div class="form-group">
                        <?php echo Form::label('login_page_panel_transparency', trans('validation.attributes.login_page_panel_transparency'), ['class' => 'col-xs-12 control-label"']); ?>

                        <div class="col-xs-12">
                            <?php echo Form::selectRange('login_page_panel_transparency', 0, 100, Appearance::getSetting('login_page_panel_transparency'), ['class' => 'form-control']); ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <?php echo Form::label('welcome_text', trans('validation.attributes.welcome_text'), ['class' => 'col-xs-12 control-label"']); ?>

                <div class="col-xs-12">
                    <?php echo Form::text('welcome_text', Appearance::getSetting('welcome_text'), ['class' => 'form-control']); ?>

                </div>
            </div>

            <div class="form-group">
                <?php echo Form::label('bottom_text', trans('validation.attributes.bottom_text'), ['class' => 'col-xs-12 control-label"']); ?>

                <div class="col-xs-12">
                    <?php echo Form::text('bottom_text', Appearance::getSetting('bottom_text'), ['class' => 'form-control']); ?>

                </div>
            </div>

            <div class="form-group">
                <?php echo Form::label('apple_store_link', trans('validation.attributes.apple_store_link'), ['class' => 'col-xs-12 control-label"']); ?>

                <div class="col-xs-12">
                    <?php echo Form::text('apple_store_link', Appearance::getSetting('apple_store_link'), ['class' => 'form-control', 'placeholder' => 'http://']); ?>

                </div>
            </div>

            <div class="form-group">
                <?php echo Form::label('google_play_link', trans('validation.attributes.google_play_link'), ['class' => 'col-xs-12 control-label"']); ?>

                <div class="col-xs-12">
                    <?php echo Form::text('google_play_link', Appearance::getSetting('google_play_link'), ['class' => 'form-control', 'placeholder' => 'http://']); ?>

                </div>
            </div>
        <?php echo Form::close(); ?>

    </div>

    <div class="panel-footer">
        <button type="submit" class="btn btn-action" onClick="$('#logos-form').submit();"><?php echo e(trans('global.save')); ?></button>
    </div>
</div>

<?php $__env->startPush('javascript'); ?>
<script>
    $(document).ready(function() {
        $(document).on('change', 'select[name="template_color"]', function () {
            _url = '<?php echo e(asset('assets/css')); ?>/' + $(this).val() + '.css';

            $("head").append('<link id="new-css" href="'+_url+'" type="text/css" rel="stylesheet" />');
        });
    });
</script>
<?php $__env->stopPush(); ?>
