<div class="table-responsive">

    <table class="table table-list" data-toggle="multiCheckbox">
        <thead>
        <tr>
            <?php if( Auth::User()->perm('tasks', 'remove') ): ?>
                <?php echo tableHeaderCheckall(['assign' => trans('front.assign'), 'do_destroy' => trans('admin.delete_selected')]); ?>

            <?php endif; ?>
            <?php echo tableHeaderSort($tasks->sorting, 'title', NULL); ?>

            <?php echo tableHeaderSort($tasks->sorting, 'device_id', NULL); ?>

            <?php echo tableHeaderSort($tasks->sorting, 'status', NULL); ?>

            <?php echo tableHeaderSort($tasks->sorting, 'priority', NULL); ?>

            <?php echo tableHeaderSort($tasks->sorting, 'invoice_number', NULL); ?>

            <?php echo tableHeaderSort($tasks->sorting, 'pickup_time_from', 'front.pickup'); ?>

            <?php echo tableHeaderSort($tasks->sorting, 'delivery_time_from', 'front.delivery'); ?>

            <th></th>
        </tr>
        </thead>
        <tbody>
        <?php if(count($tasks)): ?>
            <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <?php if( Auth::User()->perm('tasks', 'remove') ): ?>
                        <td>
                            <div class="checkbox">
                                <input type="checkbox" value="<?php echo $task->id; ?>">
                                <label></label>
                            </div>
                        </td>
                    <?php endif; ?>
                    <td>
                        <?php echo e($task->title); ?>

                    </td>
                    <td>
                        <?php echo e($task->deviceName); ?>

                    </td>
                    <td>
                        <?php echo e($task->statusName); ?>

                    </td>
                    <td>
                        <?php echo e($task->priorityName); ?>

                    </td>
                    <td>
                        <?php echo e($task->invoice_number); ?>

                    </td>
                    <td>
                        <?php echo e(Formatter::time()->format($task->pickup_time_from)); ?>

                    </td>
                    <td>
                        <?php echo e(Formatter::time()->format($task->delivery_time_from)); ?>

                    </td>
                    <td class="actions">
                        <?php if($task->lastStatus && $task->lastStatus->signature): ?>
                        <a href="<?php echo route('tasks.signature', $task->lastStatus->id); ?>" class="btn icon download" download></a>
                        <?php endif; ?>
                        <a href="javascript:" class="btn icon edit" data-url="<?php echo route('tasks.edit', $task->id); ?>" data-modal="tasks_edit"></a>
                        <a href="javascript:" class="btn icon delete" data-url="<?php echo route('tasks.do_destroy', $task->id); ?>" data-modal="tasks_destroy"></a>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <tr>
                <td class="no-data" colspan="5"><?php echo trans('front.no_tasks'); ?></td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>
</div>
<div class="nav-pagination">
    <?php if(count($tasks)): ?>
        <?php echo $tasks->setPath(route('tasks.list'))->render(); ?>

    <?php endif; ?>
</div>