<!DOCTYPE html>
<html lang="<?php echo e(Language::iso()); ?>" dir="<?php echo e(Language::dir() == 'rtl' ? 'RTL' : 'LTR'); ?>" >
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <?php if($report->getFormat() == 'xls'): ?>
            <title>Report</title>
        <?php else: ?>
            <title><?php echo e(Appearance::getSetting('server_name')); ?></title>
            <style><?php require ( base_path('public/assets/css/report.css') ); ?></style>
            <?php echo $__env->yieldContent('scripts'); ?>
            <?php echo $__env->yieldContent('styles'); ?>
        <?php endif; ?>

    </head>

    <body class="reports">
        <div class="container">
            <?php if($report->getFormat() == 'html'): ?>
            <header>
                <div class="header-left">
                    <div class="report-wrap">
                        <div class="report-logo" style="background: none;">
                            <img src="<?php echo e(Appearance::getAssetFileUrl('logo')); ?>" class="logo" alt="Logo">
                        </div>
                    </div>
                    <div class="report-curve"></div>
                </div>
                <div class="header-right"></div>
            </header>

            <?php elseif($report->getFormat() != 'xls' && Appearance::assetFileExists('logo')): ?>
                <img src="<?php echo e(Appearance::getAssetFilePath('logo')); ?>" class="logo" alt="Logo">
            <?php endif; ?>

            <?php echo $__env->yieldContent('content'); ?>

        </div>
    </body>
</html>