<div class="tab-pane-header">
    <div id="history-form" class="form-horizontal">
        <div class="form-group">
            <label class="col-xs-3 control-label"><?php echo trans('global.device'); ?>:</label>
            <div class="col-xs-9">
                <?php echo Form::select('devices', $devices, null, ['class' => 'form-control devices_list', 'data-live-search' => 'true']); ?>

            </div>
        </div>

        <div class="form-group">
            <label class="col-xs-3 control-label"><?php echo trans('global.from'); ?>:</label>
            <div class="col-xs-9">
                <div class="input-group">
                    <?php echo Form::text('from_date', $history['start'], ['class' => 'datepicker form-control']); ?>

                    <span class="input-group-btn">
                        <?php echo Form::select('from_time', getSelectTimeRange(), null, ['class' => 'form-control timeselect']); ?>

                    </span>
                </div>
            </div>
        </div>

        <div class="form-group">
            <label class="col-xs-3 control-label"><?php echo trans('global.to'); ?>:</label>
            <div class="col-xs-9">
                <div class="input-group">
                    <?php echo Form::text('to_date', $history['end'], ['class' => 'datepicker form-control']); ?>

                    <span class="input-group-btn">
                        <?php echo Form::select('to_time', getSelectTimeRange(), $history['end_time'], ['class' => 'form-control timeselect']); ?>

                    </span>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="col-xs-12 text-right">
                <a href="javascript:" class="collapsed" data-toggle="collapse" data-target="#history-advanced" data-parent="#history_tab" aria-expanded="false" aria-controls="history-advanced">
                    <?php echo e(trans('global.advanced')); ?>

                </a>
            </div>
        </div>

        <div id="history-advanced" class="group-collapse collapse" role="tabpanel" aria-expanded="false" style="height: 0px;">
            <div class="form-group">
                <label class="col-xs-3 control-label"><?php echo e(trans('validation.attributes.stops')); ?></label>
                <div class="col-xs-9">
                    <?php echo Form::select('stops', config('tobuli.stops_seconds'), 180, ['class' => 'form-control']); ?>

                </div>
            </div>
            <div class="form-group">
                <label class="col-xs-3 control-label"></label>
                <div class="col-xs-9">
                    <div class="checkbox">
                        <input id="snap_to_road" name="snap_to_road" type="checkbox" value="true">
                        <label><?php echo e(trans('front.snap_to_road')); ?></label>
                    </div>
                </div>
            </div>
        </div>

        <div class="input-group">
            <button class="btn btn-primary btn-block" type="button" onclick="app.history.get()"><?php echo trans('front.show_history'); ?></button>
            <span class="input-group-btn">
                <div class="btn-group dropdown">
                    <button class="btn btn-default" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="icon history-export"></i>
                    </button>
                    <ul class="dropdown-menu">
                        <li><a href="javascript:" onclick="app.history.export( 'gsr' )"><?php echo e(trans('front.export_gsr')); ?></a></li>
                        <li><a href="javascript:" onclick="app.history.export( 'kml' )"><?php echo e(trans('front.export_kml')); ?></a></li>
                        <li><a href="javascript:" onclick="app.history.export( 'gpx' )"><?php echo e(trans('front.export_gpx')); ?></a></li>
                        <li><a href="javascript:" onclick="app.history.export( 'csv' )"><?php echo e(trans('front.export_csv')); ?></a></li>
                    </ul>
                </div>
                <button class="btn btn-default" type="button" onclick="app.history.clear()">
                    <i class="icon history-clean"></i>
                </button>
            </span>
        </div>
    </div>
</div>
<div class="tab-pane-body">
    <div id="ajax-history"></div>
</div>