<?php $__env->startSection('title'); ?>
    <i class="icon services"></i> <?php echo e(trans('front.add_service')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
    <?php if(Auth::user()->can('view', new \Tobuli\Entities\Checklist)): ?>
    <ul class="nav nav-tabs nav-default" role="tablist">
        <li class="active"><a href="#service-tab" role="tab" data-toggle="tab"><?php echo trans('front.service'); ?></a></li>
        <li><a href="#checklists-index" role="tab" data-toggle="tab"><?php echo trans('front.checklists'); ?></a></li>
    </ul>
    <?php endif; ?>

    <div class="tab-content">
        <div id="service-tab" class="tab-pane active">
            <?php echo Form::open(['route' => 'services.store', 'method' => 'POST']); ?>

                <?php echo Form::hidden('id'); ?>

                <?php echo Form::hidden('device_id', $device_id); ?>

                <div class="form-group">
                    <?php echo Form::label('name', trans('validation.attributes.name').':'); ?>

                    <?php echo Form::text('name', null, ['class' => 'form-control']); ?>

                </div>
                <div class="form-group">
                    <?php echo Form::label('expiration_by', trans('validation.attributes.expiration_by').':'); ?>

                    <?php echo Form::select('expiration_by', $expiration_by, 1, ['class' => 'form-control']); ?>

                </div>
                <div class="form-group">
                    <?php echo Form::label('interval', trans('validation.attributes.interval').':'); ?>

                    <?php echo Form::text('interval', null, ['class' => 'form-control']); ?>

                </div>
                <div class="form-group">
                    <?php echo Form::label('last_service', trans('validation.attributes.last_service').':'); ?>

                    <?php echo Form::text('last_service', null, ['class' => 'form-control service-datepicker']); ?>

                </div>
                <div class="form-group">
                    <?php echo Form::label('trigger_event_left', trans('validation.attributes.trigger_event_left').':'); ?>

                    <?php echo Form::text('trigger_event_left', null, ['class' => 'form-control']); ?>

                </div>
                <div class="form-group">
                    <div class="checkbox">
                        <?php echo Form::checkbox('renew_after_expiration', 1, null); ?>

                        <?php echo Form::label('renew_after_expiration', trans('validation.attributes.renew_after_expiration')); ?>

                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 col-sm-6 col-xs-6">
                        <div class="form-group">
                            <?php echo Form::label('current_odometer', trans('validation.attributes.current_odometer').':'); ?>

                            <?php echo Form::text('current_odometer', $odometer_value, ['class' => 'form-control', 'disabled' => 'disabled']); ?>

                        </div>
                    </div>
                    <div class="col-md-6 col-sm-6 col-xs-6">
                        <div class="form-group">
                            <?php echo Form::label('current_engine_hours', trans('validation.attributes.current_engine_hours').':'); ?>

                            <?php echo Form::text('current_engine_hours', $engine_hours_value, ['class' => 'form-control', 'disabled' => 'disabled']); ?>

                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <?php echo Form::label('description', trans('validation.attributes.description').':'); ?>

                    <?php echo Form::text('description', null, ['class' => 'form-control']); ?>

                </div>
                <div class="form-group">
                    <?php echo Form::label('email', trans('validation.attributes.email').':'); ?>

                    <?php echo Form::text('email', null, ['class' => 'form-control']); ?>

                </div>
                <?php if(Auth::User()->sms_gateway): ?>
                    <div class="form-group">
                        <?php echo Form::label('mobile_phone', trans('validation.attributes.mobile_phone').':'); ?>

                        <?php echo Form::text('mobile_phone', null, ['class' => 'form-control']); ?>

                    </div>
                <?php endif; ?>
            <?php echo Form::close(); ?>

        </div>

        <?php if(Auth::user()->can('view', new \Tobuli\Entities\Checklist)): ?>
        <div id="checklists-index" class="tab-pane">
            <?php echo $__env->make('Frontend.Checklist.index', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('buttons'); ?>
    <button type="button" class="btn btn-action update"><?php echo trans('global.save'); ?></button>
    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo trans('global.cancel'); ?></button>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(config('addon.checklists')
        ? 'Frontend.Layouts.modal_full'
        : 'Frontend.Layouts.modal',
        config('addon.checklists')
        ? ['modal_class' => 'modal-lg']
        : [], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>