<?php if(!Auth::User()->sms_gateway): ?>
    <div class="alert alert-danger" role="alert"><?php echo trans('front.sms_gateway_disabled'); ?></div>
<?php else: ?>
    <?php if(empty($devices_sms)): ?>
        <div class="alert alert-danger" role="alert"><?php echo trans('front.no_devices_with_sim_number'); ?></div>
    <?php endif; ?>

    <div class="form-group">
        <?php echo Form::label('devices', trans('validation.attributes.devices').'*:'); ?>

        <?php if(empty($devices_sms)): ?>
            <?php echo Form::text('devices[]', null, ['class' => 'form-control', 'disabled' => 'disabled']); ?>

        <?php else: ?>
            <?php echo Form::select('devices[]', $devices_sms, isset($device_id) ? $device_id : null, ['class' => 'form-control', 'multiple' => 'multiple', 'data-live-search' => 'true', 'data-actions-box' => 'true']); ?>

        <?php endif; ?>
        <?php echo Form::hidden('devices_fake'); ?>

        <small><?php echo trans('front.add_sim_number_info'); ?></small>
    </div>

    <div class="form-group">
        <?php echo Form::label('sms_template_id', trans('validation.attributes.sms_template_id').':'); ?>

        <?php echo Form::select('sms_template_id', $sms_templates, null, ['class' => 'form-control', 'data-url' => route('user_sms_templates.get_message')]); ?>

        <small><?php echo trans('front.add_sms_template_info'); ?></small>
    </div>

    <div class="form-group">
        <?php echo Form::label('message', trans('validation.attributes.message').'*:'); ?>

        <?php echo Form::textarea('message_sms', (isset($message) ? $message : null), ['class' => 'form-control', 'rows' => 3]); ?>

        <?php echo Form::hidden('message_fake'); ?>

    </div>

    <div class="send_command_result" style="display: none;">
        <div>
            <p><?php echo trans('front.get_request'); ?>:</p>
            <p class="get_request result_parse"></p>
        </div>
        <div>
            <p><?php echo trans('front.response'); ?>:</p>
            <p class="get_result result_parse"></p>
        </div>
    </div>
<?php endif; ?>