<?php $__env->startSection('title'); ?>
    <i class="icon camera"></i> <?php echo trans('front.camera'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
    <div class="row no-padding">
        <div class="col-xs-12 col-sm-5 col-md-3 col-lg-3">
            <div class="panel panel-transparent" id="setup-form-itemsSimple">
                <div class="panel-heading">
                    <div class="panel-form panel-form-right">
                        <div class="form-group search">
                            <?php echo Form::text('search_phrase', null, ['class' => 'form-control', 'id' => 'popSearchObject', 'placeholder' => trans('front.search'), 'autocomplete' => 'off', 'data-filter' => 'true']); ?>

                        </div>
                    </div>
                    <div class="panel-title"><i class="icon device"></i> <?php echo e(trans('front.objects')); ?></div>
                </div>
                <div data-table>
                    <?php echo $__env->make('Frontend.Objects.itemsSimple', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                </div>
            </div>
        </div>

        <div class="col-xs-12 col-sm-7 col-md-3 col-lg-3">
            <div class="alert alert-success" role="alert" style="display: none;"><?php echo trans('front.command_sent'); ?></div>
            <div class="alert alert-danger main-alert" role="alert" style="display: none;"></div>
            <div class="panel panel-transparent">
                <div class="panel-heading">
                    <?php if( Auth::User()->perm('camera', 'edit') ): ?>
                    <div class="panel-form pull-right">
                        <div class="form-group">
                            <?php echo Form::open(['route' => 'send_command.gprs', 'method' => 'POST', 'id' => 'requestPhoto']); ?>

                                <?php echo Form::hidden('id'); ?>

                                <?php echo Form::hidden('device_id'); ?>

                                <?php echo Form::hidden('type', 'requestPhoto'); ?>

                                <div class="attributes"></div>
                                <button type="submit" id="takePhoto" class="btn btn-secondary" disabled="disabled">
                                    <i class="icon camera"></i> <?php echo e(trans('front.take_photo')); ?>

                                </button>
                            <?php echo Form::close(); ?>

                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="panel-title-overflow">
                        <i class="icon camera"></i> <?php echo e(trans('front.images')); ?>

                    </div>
                </div>
                <div id="ajax-photos"></div>
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
            <div class="panel panel-transparent">
                <div id="imgContainer" class="text-center"></div>

                <div id="mapWrapForPhoto">
                    <div id="mapForPhoto"></div>
                </div>
            </div>
        </div>

    </div>

    <script type="text/javascript">
        $(document).ready(function () {
            app.devices.listSimple('#ajax-items-pop', "<?php echo e(route('objects.items_simple')); ?>");

            tables.set_config('setup-form-itemsSimple', {
                url:'<?php echo e(route('objects.items_simple')); ?>'
            });

            $(document).on('click', '#imgPaginate .pagination a', function (e) {
                var $container = $('#ajax-photos');

                $.ajax({
                    type: 'GET',
                    dataType: "html",
                    url: $(this).attr('href'),
                    beforeSend: function () {
                        loader.add($container);
                    },
                    success: function (res) {
                        $($container).html(res);
                    },
                    complete: function () {
                        loader.remove($container);
                    }
                });

                e.preventDefault();
            });

            function getImages(urlStr) {

            }
        });

        $('#requestPhoto').on('submit', function (e) {
            e.preventDefault();
            $.ajax({
                type: 'POST',
                dataType: "json",
                data: $(this).serialize(),
                url: $(this).attr('action'),
                beforeSend: function () {
                },
                success: function (res) {
                    if (res.errors) {
                        $.each(res.errors, function (key, value) {
                            $('#camera_photos .alert-danger.main-alert').css('display', 'block').html(value);
                        });
                    } else if (res.error) {
                        $('#camera_photos .alert-danger.main-alert').css('display', 'block').html(res.error);
                    } else {
                        $('#camera_photos .alert-danger.main-alert').css('display', 'none');
                        app.deviceMedia.getImages($("input[name='device_id']").val(), '#ajax-photos');
                    }
                },
                complete: function () {
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Frontend.Layouts.modal_full', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>