<?php $__env->startSection('form-fields'); ?>
    <div id="braintree">
        <div class="form-group">
            <?php echo Form::label('merchantId', trans('validation.attributes.merchant_id'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::text('merchantId', settings('payments.braintree.merchantId'), ['class' => 'form-control']); ?>

            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('publicKey', trans('validation.attributes.public_key'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::text('publicKey', settings('payments.braintree.publicKey'), ['class' => 'form-control']); ?>

            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('privateKey', trans('validation.attributes.private_key'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::text('privateKey', settings('payments.braintree.privateKey'), ['class' => 'form-control']); ?>

            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('merchant_account_id', trans('validation.attributes.merchant_account_id'),
            ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::text('merchant_account_id', settings('payments.braintree.merchant_account_id'), ['class' => 'form-control']); ?>

            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('environment', trans('validation.attributes.environment'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::select('environment', config('payments.braintree.environments'), settings('payments.braintree.environment'), ['class' => 'form-control']); ?>

            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label(null, null, ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::hidden('3d_secure', 0); ?>

                <div class="checkbox">
                    <?php echo Form::checkbox('3d_secure', 1, settings('payments.braintree.3d_secure')); ?>

                    <?php echo Form::label(null, '3D secure'); ?>

                </div>
            </div>
        </div>

        <p><b><?php echo e(trans('validation.attributes.braintree_plan_ids')); ?></b></p>
        <?php if(empty($plans)): ?>
            <p><?php echo e(trans('front.plan_not_found')); ?></p>
        <?php else: ?>
            <?php $i = 0; ?>
            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan_id => $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php echo Form::hidden("billing_plans[$i]", $plan_id); ?>

                <div class="form-group plan_group">
                    <div class="col-xs-12 col-sm-4">
                        <p><b><?php echo e(trans('front.plan')); ?></b>: <?php echo e(ucfirst($plan['title'])); ?></p>
                    </div>
                    <div class="col-xs-12 col-sm-8">
                        <?php echo Form::select("plan_ids[$i]", $braintree_plan_ids, $plan['braintree_id'], ['class' => 'form-control']); ?>

                    </div>
                </div>
                <?php $i++ ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

    </div>
<?php $__env->stopSection(true); ?>
<?php echo $__env->make('Admin.Billing.Gateways.layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>