<?php $__env->startSection('title'); ?>
<?php echo e(trans('front.subscriptions')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
    <?php if($user->perm('custom_device_add', 'view')): ?>
        <div class="form-group">
            <?php echo e(trans('validation.attributes.email')); ?>: <?php echo e($user->email); ?>

        </div>

        <div class="form-group">
            <?php echo e(trans('validation.attributes.devices_limit')); ?>: <?php echo e(is_null($user->devices_limit) ? trans('front.unlimited') : $user->devices_limit); ?>

        </div>
    <?php else: ?>
        <div class="form-group">
            <?php echo e(trans('validation.attributes.email')); ?>: <?php echo e($user->email); ?>

        </div>

        <?php if(!is_null($user->billing_plan_id)): ?>
            <div class="form-group">
                <?php echo e(trans('front.plan')); ?>: <?php echo e($user->billing_plan->title); ?>


                <a href="<?php echo e(route('payments.subscriptions')); ?>" class="btn btn-action btn-xs "><?php echo e(trans('front.renew_upgrade')); ?></a>
            </div>
        <?php endif; ?>

        <div class="form-group">
            <?php echo e(trans('validation.attributes.devices_limit')); ?>: <?php echo e(is_null($user->devices_limit) ? trans('front.unlimited') : $user->devices_limit); ?>

        </div>

        <?php if($user->hasExpiration()): ?>
        <div class="form-group">
            <?php echo e(trans('front.expiration_date')); ?>: <?php echo e(Formatter::time($user->subscription_expiration)); ?> (<?php echo e($days_left); ?> <?php echo e(trans('front.days_left')); ?>)
        </div>
        <?php endif; ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('buttons'); ?>
    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(trans('global.close')); ?></button>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Frontend.Layouts.modal', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>