<?php $item = new \Tobuli\Entities\User(); ?>


<?php $__env->startSection('title'); ?>
    <i class="icon user"></i> <?php echo e(trans('admin.add_new_user')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
    <ul class="nav nav-tabs nav-default" role="tablist">
        <li class="active"><a href="#client-add-form-main" role="tab" data-toggle="tab"><?php echo e(trans('front.main')); ?></a>
        </li>
        <li><a href="#client-add-form-permissions" role="tab"
               data-toggle="tab"><?php echo e(trans('validation.attributes.permissions')); ?></a></li>
        <li><a href="#client-add-form-objects" role="tab" data-toggle="tab"><?php echo e(trans('front.objects')); ?></a></li>
        <?php if($item->hasCustomFields()): ?>
            <li><a href="#user-custom-fields" role="tab" data-toggle="tab"><?php echo trans('admin.custom_fields'); ?></a></li>
        <?php endif; ?>
        <?php if(settings('plugins.object_listview.status')): ?>
            <li><a href="#client-add-form-listview" role="tab"
                   data-toggle="tab"><?php echo e(trans('front.object_listview')); ?></a></li>
        <?php endif; ?>
    </ul>

    <?php echo Form::open(array('route' => 'admin.clients.store', 'method' => 'POST')); ?>

    <input style="display:none" type="text" name="fakeusernameremembered"/>
    <input style="display:none" type="password" name="fakepasswordremembered"/>

    <?php echo Form::hidden('id'); ?>


    <div class="tab-content">
        <div id="client-add-form-main" class="tab-pane active">
            <div class="form-group">
                <div class="checkbox">
                    <?php echo Form::checkbox('active', 1, 1); ?>

                    <?php echo Form::label(null, trans('validation.attributes.active')); ?>

                </div>
            </div>
            <div class="form-group">
                <?php echo Form::label('email', trans('validation.attributes.email').':'); ?>

                <?php echo Form::text('email', null, ['class' => 'form-control']); ?>

            </div>

            <div class="form-group">
                <?php echo Form::label('phone_number', trans('validation.attributes.phone_number').':'); ?>

                <?php echo Form::text('phone_number', null, ['class' => 'form-control']); ?>

            </div>

            <div class="row">
                <div class="col-sm-6">
                    <?php if(Auth::User()->isAdmin()): ?>
                        <div class="form-group">
                            <?php echo Form::label('group_id', trans('validation.attributes.group_id').'*:'); ?>

                            <?php echo Form::select('group_id', ['1' => trans('admin.group_1'), '3' => trans('admin.group_3'), '2' => trans('admin.group_2'), '4' => trans('admin.group_4'), '5' => trans('admin.group_5')], 2, ['class' => 'form-control', 'data-url' => route('admin.clients.get_permissions_table')]); ?>

                        </div>
                    <?php else: ?>
                        <?php echo Form::hidden('group_id', 2); ?>

                    <?php endif; ?>
                </div>

                <div class="col-sm-6">
                    <?php if(Auth::User()->isAdmin()): ?>
                        <div class="form-group field_manager_id">
                            <?php echo Form::label('manager_id', trans('validation.attributes.manager_id').':'); ?>

                            <?php echo Form::select('manager_id', $managers, null, ['class' => 'form-control', 'data-live-search' => 'true']); ?>

                        </div>
                    <?php else: ?>
                        <?php echo Form::hidden('manager_id', Auth::User()->id); ?>

                    <?php endif; ?>
                </div>
            </div>

            <div class="form-group">
                <?php echo Form::label(null, trans('validation.attributes.available_maps').':'); ?>

                <div class="checkboxes">
                    <?php echo Form::hidden('available_maps'); ?>

                    <?php $__currentLoopData = $maps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $title): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="checkbox">
                            <?php echo Form::checkbox('available_maps[]', $id, in_array($id, settings('main_settings.available_maps')) ); ?>

                            <?php echo Form::label(null, $title); ?>

                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-6 no_billing_plan">
                    <div class="form-group">
                        <?php echo Form::label('devices_limit', trans('validation.attributes.devices_limit').':'); ?>


                        <div class="input-group">
                            <div class="checkbox input-group-btn">
                                <?php echo Form::checkbox('enable_devices_limit', 1, (!is_null($objects_limit) || !is_null(settings('main_settings.devices_limit'))), !is_null($objects_limit) ? ['disabled' => 'disabled'] : []); ?>

                                <?php echo Form::label(null, null); ?>

                            </div>
                            <?php echo Form::text('devices_limit', settings('main_settings.devices_limit'), ['class' => 'form-control']); ?>

                        </div>
                        <?php if(!is_null($objects_limit)): ?>
                            <div class="help-block"> <?php echo e(trans('front.maximum_of_objects').': '.$objects_limit); ?></div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php echo Form::label('expiration_date', trans('validation.attributes.expiration_date').':'); ?>


                        <div class="input-group">
                            <div class="checkbox input-group-btn">
                                <?php echo Form::checkbox('enable_expiration_date', 1, (settings('main_settings.allow_users_registration') && !settings('main_settings.enable_plans')), ['id' => 'enable_expiration_date']); ?>

                                <?php echo Form::label(null, null); ?>

                            </div>
                            <?php $expiration_days = settings('main_settings.subscription_expiration_after_days'); ?>
                            <?php echo Form::text('expiration_date', is_null($expiration_days) ? '' : date('Y-m-d H:i:s',strtotime('+'.$expiration_days.' days')), ['class' => 'form-control datetimepicker enable_expiration_date lock']); ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <h4><?php echo e(trans('admin.password_change')); ?></h4>
            </div>

            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php echo Form::label('password', trans('validation.attributes.password').':'); ?>

                        <?php echo Form::password('password', ['class' => 'form-control']); ?>

                        <?php echo error_for('password', $errors); ?>

                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php echo Form::label('password_confirmation', trans('validation.attributes.password_confirmation').':'); ?>

                        <?php echo Form::password('password_confirmation', ['class' => 'form-control']); ?>

                        <?php echo error_for('password_confirmation', $errors); ?>

                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="checkbox">
                    <?php echo Form::checkbox('account_created', 1, 1); ?>

                    <?php echo Form::label(null, trans('front.send_account_created_email')); ?>

                </div>
            </div>
        </div>
        <div id="client-add-form-permissions" class="tab-pane">
            <?php if(!empty($plans)): ?>
                <div class="form-group">
                    <?php echo Form::label('billing_plan_id', trans('front.plan').':'); ?>

                    <?php echo Form::select('billing_plan_id', $plans, 0, ['class' => 'form-control', 'data-url' => route('admin.clients.get_permissions_table')]); ?>

                </div>
            <?php endif; ?>
            <div class="user_permissions_ajax">
                <?php echo $__env->make('Admin.Clients._perms', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            </div>
        </div>

        <div id="client-add-form-objects" class="tab-pane">
            <div class="form-group">
                <i class="icon devices"></i> <?php echo Form::label('objects', trans('validation.attributes.objects').'*:'); ?>

                <?php echo Form::select('objects[]', $devices, null, ['class' => 'form-control multiexpand', 'multiple' => 'multiple', 'data-live-search' => 'true', 'data-actions-box' => 'true']); ?>

            </div>
        </div>
        <div id="client-add-form-listview" class="tab-pane">
            <?php echo $__env->make('Frontend.ObjectsList.form', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        </div>
        <?php if($item->hasCustomFields()): ?>
            <div id="user-custom-fields" class="tab-pane">
                <?php echo $__env->make('Frontend.CustomFields.panel', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            </div>
        <?php endif; ?>
    </div>

    <?php echo Form::close(); ?>

    <script>
        $(function () {

            $('#clients_create').find('input[name="enable_devices_limit"]').trigger('change');
            $('#clients_create').find('input[name="enable_expiration_date"]').trigger('change');
            $('#clients_create').find('select[name="billing_plan_id"]').trigger('change');

            checkPerms();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Frontend.Layouts.modal', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>