<?php echo Form::open(['route' => 'sharing.send', 'method' => 'POST', 'id' => 'sharing_send']); ?>

    <div class="form-group">
        <div class="radio-inline">
            <?php echo Form::radio('expiration_by', 'none', true); ?>

            <?php echo Form::label('expiration_by', trans('front.none') ); ?>

        </div>
        <div class="radio-inline">
            <?php echo Form::radio('expiration_by', 'duration', false); ?>

            <?php echo Form::label('expiration_by', trans('front.duration') ); ?>

        </div>
        <div class="radio-inline">
            <?php echo Form::radio('expiration_by', 'date', false); ?>

            <?php echo Form::label('expiration_by', trans('global.date') ); ?>

        </div>
    </div>

    <div class="form-group expiration_by expiration_by_date">
        <?php echo Form::label('expiration_date', trans('validation.attributes.expiration_date').':'); ?>

        <?php echo Form::text('expiration_date', null, ['class' => 'form-control datetimepicker']); ?>

    </div>

    <div class="form-group expiration_by expiration_by_duration">
        <?php echo Form::label('duration', trans('front.duration').':'); ?>

        <div class="input-group">
            <?php echo Form::select('duration', $durationTimes, null, ['class' => 'form-control', 'data-icon' => 'icon time']); ?>

        </div>
    </div>

    <div class="form-group delete_after_expiration">
        <div class="checkbox">
            <?php echo Form::hidden('delete_after_expiration', 0); ?>

            <?php echo Form::checkbox('delete_after_expiration', 1, false); ?>

            <?php echo Form::label('delete_after_expiration', trans('validation.attributes.delete_after_expiration') ); ?>

        </div>
    </div>

    <div class="form-group">
        <?php echo Form::label('devices', trans('validation.attributes.devices').'*:'); ?>

        <?php echo Form::select('devices[]', $devices, $selectedDevices, ['class' => 'form-control multiexpand', 'multiple' => 'multiple', 'data-live-search' => 'true', 'data-actions-box' => 'true']); ?>

    </div>

    <?php if(Auth::user()->canSendSms()): ?>
    <div class="form-group">
        <?php echo Form::label('sms', trans('validation.attributes.sms').':'); ?>

        <div class="input-group">
            <div class="checkbox input-group-btn">
                <?php echo Form::hidden('send_sms', 0); ?>

                <?php echo Form::checkbox('send_sms', 1, false, ['data-disabler' => '#sms;disable']); ?>

                <?php echo Form::label(null); ?>

            </div>
            <?php echo Form::text('sms', null, ['class' => 'form-control']); ?>

        </div>
        <small><?php echo trans('front.sms_semicolon'); ?></small>
    </div>
    <?php endif; ?>

    <div class="form-group">
        <?php echo Form::label('email', trans('validation.attributes.email').':'); ?>

        <div class="input-group">
            <div class="checkbox input-group-btn">
                <?php echo Form::hidden('send_email', 0); ?>

                <?php echo Form::checkbox('send_email', 1, false, ['data-disabler' => '#email;disable']); ?>

                <?php echo Form::label(null); ?>

            </div>
            <?php echo Form::text('email', null, ['class' => 'form-control']); ?>

        </div>
        <small><?php echo trans('front.email_semicolon'); ?></small>
    </div>
<?php echo Form::close(); ?>


<script>
    $(document).ready(function() {
        $('input[name="send_via"]').on('change', function() {
            var value = $(this).val(),
                checked = $(this).is(':checked');

            $('.send_via').hide();

            if ( ! checked)
                return;

            $('.send_via_' + value).show();
        });
        $('input[name="send_via"]:checked').trigger('change');

        $('input[name="expiration_by"]').on('change', function() {
            var value = $(this).val(),
                checked = $(this).is(':checked');

            $('.expiration_by, .form-group.delete_after_expiration').hide();

            if ( ! checked)
                return;

            $('.expiration_by_' + value).show();

            if (['duration', 'date'].includes(value)) {
                $('.form-group.delete_after_expiration').show();
            }
        });
        $('input[name="expiration_by"]:checked').trigger('change');
    });
</script>
